<?php
// Script to test SMTP and IMAP credentials

require_once __DIR__ . '/../config/credentials.php';

$credentials = require __DIR__ . '/../config/credentials.php';
$email_config = $credentials['email'];

echo "🔐 Test des identifiants Email\n";
echo str_repeat("=", 60) . "\n\n";

echo "📧 Configuration actuelle:\n";
echo "   - Email: {$email_config['address']}\n";
echo "   - IMAP Host: {$email_config['imap_host']}\n";
echo "   - SMTP Host: {$email_config['smtp_host']}\n";
echo "   - SMTP Port: {$email_config['smtp_port']}\n";
echo "   - Password: " . str_repeat("*", strlen($email_config['password'])) . "\n\n";

// Test IMAP connection
echo "🔍 Test de connexion IMAP...\n";
$imap_server = "{" . $email_config['imap_host'] . ":993/imap/ssl}INBOX";

try {
    $imap = @imap_open(
        $imap_server,
        $email_config['address'],
        $email_config['password']
    );

    if ($imap) {
        echo "   ✅ Connexion IMAP réussie!\n";

        // Get mailbox info
        $check = imap_check($imap);
        echo "   - Nombre de messages: {$check->Nmsgs}\n";

        // Get unread count
        $unread = imap_search($imap, 'UNSEEN');
        $unread_count = $unread ? count($unread) : 0;
        echo "   - Messages non lus: $unread_count\n";

        imap_close($imap);
    } else {
        echo "   ❌ Échec de connexion IMAP\n";
        echo "   Erreur: " . imap_last_error() . "\n";
    }
} catch (Exception $e) {
    echo "   ❌ Erreur IMAP: " . $e->getMessage() . "\n";
}

// Test SMTP connection (basic socket test)
echo "\n📤 Test de connexion SMTP...\n";

try {
    $smtp_host = $email_config['smtp_host'];
    $smtp_port = $email_config['smtp_port'];

    $socket = @fsockopen($smtp_host, $smtp_port, $errno, $errstr, 10);

    if ($socket) {
        echo "   ✅ Connexion socket SMTP réussie!\n";

        // Read server response
        $response = fgets($socket, 4096);
        echo "   - Réponse serveur: " . trim($response) . "\n";

        fclose($socket);

        // Note: Full SMTP auth test requires PHPMailer or similar
        echo "   ℹ️  Test d'authentification SMTP complet nécessite un envoi réel\n";
    } else {
        echo "   ❌ Échec de connexion SMTP\n";
        echo "   Erreur: $errstr ($errno)\n";
    }
} catch (Exception $e) {
    echo "   ❌ Erreur SMTP: " . $e->getMessage() . "\n";
}

echo "\n" . str_repeat("=", 60) . "\n";
echo "✅ Test terminé\n";
