<?php
// Script to search for customer by email across all PrestaShop sites
// Target: archdelgaudio62@gmail.com

require_once __DIR__ . '/../config/credentials.php';

$credentials = require __DIR__ . '/../config/credentials.php';
$shops = $credentials['prestashop'];

$email = 'archdelgaudio62@gmail.com';

echo "🔍 Recherche du client: $email\n";
echo str_repeat("=", 60) . "\n\n";

foreach ($shops as $id => $shop) {
    echo "🏪 Vérification: {$shop['name']}\n";

    $url = rtrim($shop['url'], '/') . '/api/customers';
    $key = $shop['key'];

    // Search by email
    $queryUrl = $url . "?filter[email]=" . urlencode($email) . "&display=full&output_format=JSON";

    $context = stream_context_create([
        'http' => [
            'header' => "Authorization: Basic " . base64_encode($key . ":"),
            'timeout' => 10
        ]
    ]);

    try {
        $response = @file_get_contents($queryUrl, false, $context);

        if ($response === false) {
            echo "   ❌ Erreur de connexion\n";
            continue;
        }

        $json = json_decode($response, true);

        if (isset($json['customers']) && !empty($json['customers'])) {
            echo "   ✅ CLIENT TROUVÉ!\n\n";
            $customer = $json['customers'][0];

            echo "   👤 Informations client:\n";
            echo "   - ID: {$customer['id']}\n";
            echo "   - Nom: {$customer['firstname']} {$customer['lastname']}\n";
            echo "   - Email: {$customer['email']}\n";
            echo "   - Date inscription: {$customer['date_add']}\n";

            // Now search for orders
            echo "\n   📦 Recherche des commandes...\n";
            $ordersUrl = rtrim($shop['url'], '/') . '/api/orders';
            $ordersQuery = $ordersUrl . "?filter[id_customer]={$customer['id']}&display=full&output_format=JSON&sort=[id_DESC]";

            $ordersResponse = @file_get_contents($ordersQuery, false, $context);

            if ($ordersResponse) {
                $ordersJson = json_decode($ordersResponse, true);

                if (isset($ordersJson['orders']) && !empty($ordersJson['orders'])) {
                    echo "   - Nombre de commandes: " . count($ordersJson['orders']) . "\n\n";

                    foreach ($ordersJson['orders'] as $order) {
                        echo "   📋 Commande #{$order['id']}\n";
                        echo "      - Référence: {$order['reference']}\n";
                        echo "      - Date: {$order['date_add']}\n";
                        echo "      - Total: {$order['total_paid']} EUR\n";
                        echo "      - Statut: {$order['current_state']}\n";
                        echo "\n";
                    }
                } else {
                    echo "   - Aucune commande trouvée\n\n";
                }
            }

            exit(0);
        } else {
            echo "   ⚪ Non trouvé\n";
        }

    } catch (Exception $e) {
        echo "   ❌ Erreur: " . $e->getMessage() . "\n";
    }
}

echo "\n❌ Client $email introuvable sur tous les sites.\n";
