<?php
// scripts/quick_fix_headers.php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/CsvHandler.php';
require_once __DIR__ . '/../core/Logger.php';

Logger::info("--- START QUICK HEADER FIX ---");

$queue = CsvHandler::read(FILE_QUEUE);
if (empty($queue)) {
    Logger::info("Queue vide.");
    exit(0);
}

$updated = false;
$newQueue = [];

foreach ($queue as $item) {
    if (!isset($item['last_order_date'])) {
        $item['last_order_date'] = '';
        $updated = true;
    }
    $newQueue[] = $item;
}

if ($updated) {
    // Backup
    copy(FILE_QUEUE, FILE_QUEUE . '.bak_fix');

    // Save
    // Manual overwrite to ensure we control the write
    $handle = fopen(FILE_QUEUE, 'w');
    if ($handle) {
        // Headers from first item
        fputcsv($handle, array_keys($newQueue[0]));
        foreach ($newQueue as $row) {
            fputcsv($handle, $row);
        }
        fclose($handle);
        Logger::info("Headers updated successfully.");
        echo "Headers updated.\n";
    } else {
        Logger::error("Failed to write CSV.");
        echo "Failed to write CSV.\n";
    }
} else {
    Logger::info("No header update needed.");
    echo "No update needed.\n";
}
