<?php
// scripts/quick_fix_clients.php

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/CsvHandler.php';

echo "🛠️ Application des correctifs immédiats...\n";

$queue = CsvHandler::read(FILE_QUEUE);
$modified = false;
$count = 0;

foreach ($queue as &$row) {
    // Eric - Identification-plates.com (ID 6) - Client 4313
    if ($row['email'] === 'eric@eimberk.fr') {
        $row['tag_zimbra'] = 'Yellow';
        $row['shop_id'] = '6';
        $row['client_id'] = '4313';
        $modified = true;
        $count++;
    }
    // Robert - Identification-plates.com (ID 6) - Client 4332
    if ($row['email'] === 'rwcordell@earthlink.net') {
        $row['tag_zimbra'] = 'Yellow';
        $row['shop_id'] = '6';
        $row['client_id'] = '4332';
        $modified = true;
        $count++;
    }
}

if ($modified) {
    // Backup
    copy(FILE_QUEUE, FILE_QUEUE . '.bak.quick');

    $fp = fopen(FILE_QUEUE, 'w');
    if ($fp) {
        fputcsv($fp, array_keys($queue[0]));
        foreach ($queue as $row) {
            fputcsv($fp, $row);
        }
        fclose($fp);
        echo "✅ $count entrées mises à jour pour Eric et Robert.\n";
    } else {
        echo "❌ Erreur écriture CSV.\n";
    }
} else {
    echo "ℹ️ Aucun changement nécessaire (déjà à jour ?).\n";
}
