<?php
// scripts/diagnose_presta.php
require_once __DIR__ . '/../config/config.php';

$creds = require __DIR__ . '/../config/credentials.php';
$shops = $creds['prestashop'];

echo "--- DIAGNOSTIC PRESTASHOP ---\n";

foreach ($shops as $id => $shop) {
    if (!isset($shop['url']))
        continue;

    $url = rtrim($shop['url'], '/') . '/api/customers?limit=1';
    $key = $shop['key'];

    echo "Checking Shop $id ({$shop['name']})...\n";
    echo "  URL: $url\n";

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_USERPWD, $key . ':');
    curl_setopt($ch, CURLOPT_TIMEOUT, 10);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Debug only
    curl_setopt($ch, CURLOPT_VERBOSE, false);

    $start = microtime(true);
    $response = curl_exec($ch);
    $duration = microtime(true) - $start;

    if ($response === false) {
        echo "  ❌ CURL ERROR: " . curl_error($ch) . " (Errno: " . curl_errno($ch) . ")\n";
    } else {
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        echo "  ✅ HTTP CODE: $httpCode\n";
        echo "  ⏱️ Duration: " . round($duration, 3) . "s\n";
        echo "  bytes: " . strlen($response) . "\n";
        if ($httpCode != 200) {
            echo "  ⚠️ Response: " . substr($response, 0, 100) . "...\n";
        }
    }
    curl_close($ch);
    echo "--------------------------\n";
}
echo "--- END DIAGNOSTIC ---\n";
