<?php
// scripts/deduplicate_strict.php

$file = __DIR__ . '/../data/queue.csv';
if (!file_exists($file)) {
    die("File not found\n");
}

$handle = fopen($file, 'r');
if (!$handle) {
    die("Cannot open file\n");
}

$header = fgetcsv($handle);
$unique = [];
$totalRows = 0;
$duplicatesRemoved = 0;

while (($row = fgetcsv($handle)) !== false) {
    $totalRows++;
    $uid = $row[0]; // ID is the first column
    if (empty($uid))
        continue;

    if (isset($unique[$uid])) {
        $duplicatesRemoved++;
    }
    // Keep the latest one
    $unique[$uid] = $row;
}
fclose($handle);

if ($duplicatesRemoved > 0) {
    $handle = fopen($file, 'w');
    fputcsv($handle, $header);
    foreach ($unique as $row) {
        fputcsv($handle, $row);
    }
    fclose($handle);
    echo "Deduplication Complete: Removed $duplicatesRemoved duplicates out of $totalRows rows.\n";
} else {
    echo "No duplicates found in $totalRows rows.\n";
}
