<?php
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/nav.php';
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/CsvHandler.php';
require_once __DIR__ . '/../core/ImapClient.php';

$fullQueue = CsvHandler::read(FILE_QUEUE);

require_once __DIR__ . '/../core/SpamFilter.php';

// 1. Sync Unread UIDs
$unreadUids = isset($GLOBALS['globalUnreadUids']) ? $GLOBALS['globalUnreadUids'] : [];
if (empty($unreadUids)) {
    try {
        $imap = new ImapClient();
        $unreadUids = $imap->getUnreadUids();
        $imap->close();
    } catch (Exception $e) {
        $unreadUids = []; // Fallback
    }
}

// 2. Filter Main Queue (Exclude Spam, Suspicion, and Payplug)
$activeQueue = array_filter($fullQueue, function ($item) use ($unreadUids) {
    // Exclude Payplug automatic messages
    if (($item['status'] ?? '') === 'PAYPLUG_AUTO') {
        return false;
    }

    if (SpamFilter::getTargetTab($item) !== 'PENDING') {
        return false;
    }

    if (empty($unreadUids))
        return true;
    return in_array($item['id'], $unreadUids);
});

// 4. SORT BY DATE DESC (Newest First)
usort($activeQueue, function ($a, $b) {
    return strtotime($b['date_received']) <=> strtotime($a['date_received']);
});

// Load Shop Names for Display
$creds = require __DIR__ . '/../config/credentials.php';
$shopMap = [];
if (isset($creds['prestashop'])) {
    foreach ($creds['prestashop'] as $sid => $sdata) {
        $shopMap[$sid] = $sdata['name'];
    }
}


function renderMainTable($data, $shopMap)
{
    if (empty($data)) {
        echo '<div class="text-center py-5 text-muted">Aucun mail en attente (Non lu).</div>';
        return;
    }
    echo '<div class="table-responsive">';
    echo '<table class="table table-hover table-sm mb-0 align-middle" style="font-size: 0.85rem; table-layout: fixed; width: 100%;">';
    echo '<thead class="table-light"><tr><th style="width: 5%;">ID</th><th style="width: 8%;">Reçu</th><th style="width: 8%;">Dernière Cmd</th><th style="width: 15%;">Client</th><th style="width: 13%;">Site</th><th style="width: 22%;">Sujet</th><th style="width: 5%;">Tag</th><th style="width: 24%;">Actions</th></tr></thead>';
    echo '<tbody>';
    $count = 1;
    foreach ($data as $item) {
        $id = $item['id'];
        $ts = strtotime($item['date_received']);
        $isRecent = (time() - $ts) < (15 * 86400); // 15 days
        $dateStyle = $isRecent ? 'color: #ff4444; font-weight: bold;' : '';

        echo "<tr id='row-$id'>";
        echo "<td class='text-muted small' style='overflow: hidden; text-overflow: ellipsis;'>#$id</td>";
        echo "<td class='small text-nowrap' style='$dateStyle'>" . date('d-m H:i', $ts) . "</td>";

        $lastOrder = $item['last_order_date'] ?? '';
        $lastOrderDisplay = '';
        if (!empty($lastOrder)) {
            $loTs = strtotime($lastOrder);
            $lastOrderDisplay = date('d-m-Y', $loTs);
        }
        echo "<td class='small text-muted text-nowrap'>" . $lastOrderDisplay . "</td>";

        echo "<td style='overflow: hidden; text-overflow: ellipsis; white-space: nowrap;'><small><strong>" . htmlspecialchars($item['email']) . "</strong></small></td>";

        $shopName = '';
        if (!empty($item['shop_id']) && isset($shopMap[$item['shop_id']])) {
            $shopName = $shopMap[$item['shop_id']];
            // Simplify names
            $shopName = str_replace(['https://', 'http://', 'www.'], '', $shopName);
            $shopName = ucfirst($shopName);
        }
        echo "<td style='overflow: hidden; text-overflow: ellipsis; white-space: nowrap;' title='" . htmlspecialchars($shopName) . "'><small class='text-primary'>" . htmlspecialchars($shopName) . "</small></td>";

        echo "<td style='overflow: hidden; text-overflow: ellipsis; white-space: nowrap;' title='" . htmlspecialchars($item['subject']) . "'><small>" . htmlspecialchars($item['subject']) . "</small></td>";

        echo "<td><span class='badge tag-" . ($item['tag_zimbra'] ?? 'Default') . "' style='font-size: 0.7rem; padding: 2px 4px;'>" . ($item['tag_zimbra'] ?? '?') . "</span></td>";

        echo "<td class='text-end' style='white-space: nowrap;'>";
        echo "<div class='btn-group-sm api-actions'>";
        echo "<button class='btn btn-danger btn-sm me-1' onclick=\"performAction('trash', '$id')\" style='padding: 2px 6px; font-size: 0.75rem;'>⛔</button>";
        echo "<button class='btn btn-primary btn-sm me-1' onclick=\"viewDraft('$id')\" style='padding: 2px 6px; font-size: 0.75rem;'>🤖 IA</button>";
        echo "<button class='btn btn-warning btn-sm ms-1 dropdown-toggle' data-bs-toggle='dropdown' style='padding: 2px 6px; font-size: 0.75rem;'>📋</button>";
        echo "<ul class='dropdown-menu'>";
        foreach (['Yellow' => 'Client', 'Red' => 'Cmd', 'Green' => 'Erreur', 'Blue' => 'Livraison'] as $t => $l) {
            echo "<li><a class='dropdown-item' href='#' onclick=\"performAction('reclassify', '$id', '$t')\">$l</a></li>";
        }
        echo "</ul>";
        echo "</div>";
        echo "<div class='loader text-primary' id='loader-$id'><div class='spinner-border spinner-border-sm'></div></div>";

        // Hidden Data for Modals
        echo "<div id='body-$id' style='display:none'>" . htmlspecialchars($item['body'] ?? '(Vide)') . "</div>";
        echo "<div id='draft-$id' style='display:none'>" . htmlspecialchars($item['grok_response'] ?? '(Pas de brouillon généré)') . "</div>";

        echo "</td></tr>";
    }
    echo '</tbody></table></div>';
}
?>

<div class="card shadow border-0">
    <div
        class="card-header bg-dark text-white border-bottom border-secondary d-flex justify-content-between align-items-center">
        <span><i class="bi bi-inbox"></i> Emails en Attente</span>
        <a href="envoyee.php" class="btn btn-outline-success btn-sm">
            <i class="bi bi-send-check"></i> Voir Historique Envoyés
        </a>
    </div>
    <div class="card-body p-0">
        <?php renderMainTable($activeQueue, $shopMap); ?>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>