</div> <!-- End Container -->

<!-- Email Modal -->
<div class="modal fade" id="emailModal" tabindex="-1">
    <div class="modal-dialog modal-xl modal-dialog-scrollable">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="emailModalLabel">Message</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="emailModalLoading" style="display:none;" class="text-center p-4">
                    <div class="spinner-border text-primary"></div>
                    <p class="mt-2">Analyse IA en cours...</p>
                </div>
                <div id="emailModalContent" class="row"></div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-success" id="btnSendDraft" style="display:none;">📤 Envoyer au
                    client</button>
                <button type="button" class="btn btn-warning" id="btnRegenerate" style="display:none;">🔄
                    Regénérer</button>
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fermer</button>
            </div>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // Shared JS Functions

    function performAction(action, id, param = null) {
        if (!confirm('Confirmer ?')) return;
        const row = document.getElementById('row-' + id);
        const loader = document.getElementById('loader-' + id);
        const btns = row.querySelector('.api-actions');

        btns.style.display = 'none';
        if (loader) loader.style.display = 'block';

        let url = 'action.php?action=' + action + '&id=' + id;
        if (param) url += '&new_tag=' + param;

        fetch(url).then(r => r.json()).then(data => {
            if (data.success) {
                if (action === 'reclassify') location.reload();
                else if (action === 'accept') window.location.href = 'envoyee.php';
                else if (row) row.remove();
            } else {
                alert('Erreur: ' + (data.message || data.error));
                btns.style.display = 'block';
                if (loader) loader.style.display = 'none';
            }
        });
    }

    function forceUpdate() {
        const btn = document.getElementById('btn-force-update');
        const originalText = btn.innerHTML;

        btn.disabled = true;
        btn.innerHTML = '⏳ Scan Zimbra en cours...';

        fetch('action.php?action=force_scan')
            .then(r => r.json())
            .then(data => {
                location.reload();
            })
            .catch(e => {
                alert("Erreur scan: " + e);
                location.reload();
            });
    }

    function emptyTrash() {
        if (!confirm('⚠️ Vider la corbeille Zimbra ?\nCela prendra au moins 60 secondes (Sécurité).')) return;

        const btn = document.getElementById('btn-trash');
        const originalText = btn.innerHTML;
        btn.disabled = true;
        btn.innerHTML = '⏳ Traitement en cours (60s)...';

        fetch('action.php?action=expunge').then(r => r.json()).then(data => {
            alert(data.message || 'Terminé');
            btn.innerHTML = originalText;
            btn.disabled = false;
        }).catch(e => {
            alert('Erreur réseau');
            btn.disabled = false;
            btn.innerHTML = originalText;
        });
    }

    // Viewer Functions
    let currentDraftId = null;
    let currentDraftText = null;

    function viewDraft(id, force = false) {
        const draftContainer = document.getElementById('draft-' + id);
        let draftText = draftContainer.innerHTML;
        const modalContent = document.getElementById('emailModalContent');
        const loader = document.getElementById('emailModalLoading');
        const btnRegen = document.getElementById('btnRegenerate');
        const btnSend = document.getElementById('btnSendDraft');
        const modalEl = document.getElementById('emailModal');
        const modalObj = bootstrap.Modal.getInstance(modalEl) || new bootstrap.Modal(modalEl);

        currentDraftId = id;
        document.getElementById('emailModalLabel').innerText = "🤖 Proposition de Réponse IA";

        // Decide if we need to generate
        const isEmpty = !draftText || draftText.includes('(Pas de brouillon');

        if (isEmpty || force) {
            modalContent.innerHTML = "";
            loader.style.display = 'block';
            btnRegen.style.display = 'none';
            btnSend.style.display = 'none';
            modalObj.show();

            fetch('action.php?action=generate_ai_draft&id=' + id)
                .then(r => r.json())
                .then(data => {
                    loader.style.display = 'none';
                    if (data.success) {
                        displayDraft(data.draft, modalContent, btnRegen, btnSend, id);
                        draftContainer.innerHTML = data.draft; // Update hidden cache
                    } else {
                        modalContent.innerHTML = "<div class='alert alert-danger'>Erreur: " + data.error + "</div>";
                    }
                }).catch(e => {
                    loader.style.display = 'none';
                    modalContent.innerHTML = "<div class='alert alert-danger'>Erreur réseau: " + e + "</div>";
                });
        } else {
            displayDraft(draftText, modalContent, btnRegen, btnSend, id);
            loader.style.display = 'none';
            modalObj.show();
        }
    }

    function displayDraft(draft, modalContent, btnRegen, btnSend, id) {
        // Get client email body from hidden div
        const clientBodyDiv = document.getElementById('body-' + id);
        const clientBody = clientBodyDiv ? clientBodyDiv.innerHTML : 'Message non disponible';

        // Try to parse as JSON (multilingual format)
        try {
            const parsed = JSON.parse(draft);
            if (parsed.type === 'multilingual') {
                // 3-COLUMN LAYOUT for multilingual
                const questionTranslation = parsed.question_translation ? `
                    <hr class="my-2">
                    <div class="p-2 bg-info bg-opacity-10 rounded" style="max-height: 200px; overflow-y: auto; white-space: pre-wrap; font-size: 0.85rem;">
                        <small class="text-info fw-bold">🇫🇷 Traduction:</small><br>
                        ${parsed.question_translation}
                    </div>
                ` : '';

                modalContent.innerHTML = `
                    <!-- Column 1: Client Question + Translation -->
                    <div class="col-md-4 border-end">
                        <h6 class="text-secondary mb-3"><i class="bi bi-envelope"></i> Question du client</h6>
                        <div class="p-2 bg-light rounded mb-2" style="max-height: 400px; overflow-y: auto; white-space: pre-wrap; font-size: 0.9rem;">${clientBody}</div>
                        ${questionTranslation}
                    </div>
                    
                    <!-- Column 2: Response in Client's Language -->
                    <div class="col-md-4 border-end">
                        <h6 class="text-primary mb-3"><i class="bi bi-chat-dots"></i> Réponse au client</h6>
                        <div class="p-2 bg-primary bg-opacity-10 rounded" style="max-height: 400px; overflow-y: auto; white-space: pre-wrap; font-size: 0.9rem;">${parsed.original}</div>
                    </div>
                    
                    <!-- Column 3: French Translation -->
                    <div class="col-md-4">
                        <h6 class="text-info mb-3">🇫🇷 Traduction (pour vous)</h6>
                        <div class="p-2 bg-info bg-opacity-10 rounded" style="max-height: 400px; overflow-y: auto; white-space: pre-wrap; font-size: 0.9rem;">${parsed.translation}</div>
                    </div>
                `;
                currentDraftText = parsed.original; // Send original to client
            }
        } catch (e) {
            // Not JSON - French response
            // 2-COLUMN LAYOUT for French
            modalContent.innerHTML = `
                <!-- Column 1: Client Question -->
                <div class="col-md-6 border-end">
                    <h6 class="text-secondary mb-3"><i class="bi bi-envelope"></i> Question du client</h6>
                    <div class="p-2 bg-light rounded mb-2" style="max-height: 400px; overflow-y: auto; white-space: pre-wrap; font-size: 0.9rem;">${clientBody}</div>
                </div>
                
                <!-- Column 2: Response in French -->
                <div class="col-md-6">
                    <h6 class="text-primary mb-3"><i class="bi bi-chat-dots"></i> Réponse au client</h6>
                    <div class="p-2 bg-primary bg-opacity-10 rounded" style="max-height: 400px; overflow-y: auto; white-space: pre-wrap; font-size: 0.9rem;">${draft}</div>
                </div>
            `;
            currentDraftText = draft;
        }

        btnRegen.style.display = 'inline-block';
        btnRegen.onclick = () => viewDraft(id, true);

        btnSend.style.display = 'inline-block';
        btnSend.onclick = () => sendDraft(id);
    }

    function sendDraft(id) {
        if (!confirm('Êtes-vous sûr de vouloir envoyer cette réponse au client ?')) return;

        const formData = new FormData();
        formData.append('draft', currentDraftText);

        fetch('action.php?action=send_ai_draft&id=' + id, {
            method: 'POST',
            body: formData
        })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    alert('✅ ' + data.message);
                    window.location.href = 'envoyee.php';
                } else {
                    alert('❌ Erreur: ' + data.error);
                }
            })
            .catch(e => {
                alert('❌ Erreur réseau: ' + e);
            });
    }

    function viewEmail(id) {
        const body = document.getElementById('body-' + id).innerHTML;
        const txt = document.createElement('textarea');
        txt.innerHTML = body;
        document.getElementById('emailModalLabel').innerText = "Message Client";
        document.getElementById('emailModalBody').innerHTML = body;
        document.getElementById('emailModalBody').className = "text-success";
        new bootstrap.Modal(document.getElementById('emailModal')).show();
    }
</script>
</body>

</html>