<?php
// public/envoyee.php
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/nav.php';
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/CsvHandler.php';

$archives = CsvHandler::read(FILE_ARCHIVES);

// SORT BY DATE DESC (Newest First)
usort($archives, function ($a, $b) {
    $dateA = isset($a['date_sent']) ? strtotime($a['date_sent']) : 0;
    $dateB = isset($b['date_sent']) ? strtotime($b['date_sent']) : 0;
    return $dateB <=> $dateA;
});

function renderArchivesTable($data)
{
    if (empty($data)) {
        echo '<div class="text-center py-5 text-muted">Aucun message envoyé pour le moment.</div>';
        return;
    }
    echo '<div class="table-responsive">';
    echo '<table class="table table-hover table-sm mb-0 align-middle" style="font-size: 0.9rem;">';
    echo '<thead class="table-light"><tr><th>ID</th><th>Date Envoi</th><th>Destinataire</th><th>Sujet</th><th>Réponse IA</th><th class="text-end">Actions</th></tr></thead>';
    echo '<tbody>';
    foreach ($data as $item) {
        $id = $item['id'];
        $dateSent = isset($item['date_sent']) ? date('d-m H:i', strtotime($item['date_sent'])) : 'N/A';

        echo "<tr>";
        echo "<td class='text-muted small'>#$id</td>";
        echo "<td class='small text-nowrap'>$dateSent</td>";
        echo "<td><strong>" . htmlspecialchars($item['email'] ?? 'N/A') . "</strong></td>";
        echo "<td><small class='text-muted'>" . htmlspecialchars($item['subject'] ?? 'N/A') . "</small></td>";

        $response = $item['final_response'] ?? $item['grok_response'] ?? '';
        $shortResponse = (strlen($response) > 50) ? substr($response, 0, 50) . '...' : $response;
        echo "<td><small class='text-muted'>" . htmlspecialchars($shortResponse) . "</small></td>";

        echo "<td class='text-end'>";
        echo "<button class='btn btn-outline-info btn-sm' onclick=\"viewArchivedMsg('$id')\">👀 Voir</button>";

        // Hidden Data for Modals
        echo "<div id='full-response-$id' style='display:none'>" . htmlspecialchars($response) . "</div>";
        echo "</td></tr>";
    }
    echo '</tbody></table></div>';
}
?>

<div class="card shadow border-0">
    <div class="card-header bg-dark text-success border-bottom border-secondary">
        <i class="bi bi-send-check"></i> Historique des Emails Envoyés
    </div>
    <div class="card-body p-0">
        <?php renderArchivesTable($archives); ?>
    </div>
</div>

<!-- Modal Visualisation Message Envoyé -->
<div class="modal fade" id="archivedModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Message Envoyé</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div class="p-3 bg-dark text-light rounded" id="archivedModalBody"
                    style="white-space: pre-wrap; font-family: 'JetBrains Mono', monospace; font-size: 0.9rem; border: 1px solid #333;">
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fermer</button>
            </div>
        </div>
    </div>
</div>

<script>
    function viewArchivedMsg(id) {
        const content = document.getElementById('full-response-' + id).innerHTML;
        document.getElementById('archivedModalBody').innerText = content;
        new bootstrap.Modal(document.getElementById('archivedModal')).show();
    }
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>