<?php
// core/SmtpSender.php

require_once __DIR__ . '/Logger.php';

class SmtpSender
{
    private $host;
    private $port;
    private $username;
    private $password;

    public function __construct()
    {
        $creds = require __DIR__ . '/../config/credentials.php';
        $this->host = $creds['email']['smtp_host'];
        // Force SSL for Free usually 465
        $this->port = $creds['email']['smtp_port'];
        $this->username = $creds['email']['address'];
        $this->password = $creds['email']['password'];
    }

    public function send($to, $subject, $body)
    {
        $socket = fsockopen("ssl://" . $this->host, $this->port, $errno, $errstr, 30);
        if (!$socket) {
            Logger::error("SMTP Connection failed: $errstr ($errno)");
            return false;
        }

        $this->read($socket); // Welcome message

        // HELLO
        $this->write($socket, "EHLO " . gethostname());
        $this->read($socket);

        // AUTH
        $this->write($socket, "AUTH LOGIN");
        $this->read($socket);
        $this->write($socket, base64_encode($this->username));
        $this->read($socket);
        $this->write($socket, base64_encode($this->password));
        $response = $this->read($socket);

        if (strpos($response, '235') === false) {
            Logger::error("SMTP Auth failed: $response");
            fclose($socket);
            return false;
        }

        // MAIL FROM
        $this->write($socket, "MAIL FROM: <" . $this->username . ">");
        $this->read($socket);

        // RCPT TO
        $this->write($socket, "RCPT TO: <" . $to . ">");
        $this->read($socket);

        // DATA
        $this->write($socket, "DATA");
        $this->read($socket);

        // HEADERS & BODY
        $headers = "MIME-Version: 1.0\r\n";
        $headers .= "Content-type: text/plain; charset=UTF-8\r\n";
        $headers .= "From: " . $this->username . "\r\n";
        $headers .= "To: " . $to . "\r\n";
        $headers .= "Subject: " . $subject . "\r\n";

        $this->write($socket, $headers . "\r\n" . $body . "\r\n.");
        $response = $this->read($socket);

        $success = (strpos($response, '250') !== false);

        // QUIT
        $this->write($socket, "QUIT");
        fclose($socket);

        if ($success) {
            Logger::info("Email sent to $to");
        } else {
            Logger::error("Failed to send email to $to: $response");
        }

        return $success;
    }

    private function write($socket, $cmd)
    {
        fwrite($socket, $cmd . "\r\n");
    }

    private function read($socket)
    {
        $response = "";
        while ($str = fgets($socket, 515)) {
            $response .= $str;
            if (substr($str, 3, 1) == " ")
                break;
        }
        return $response;
    }
}
