<?php
// config/config.php

// Charger les identifiants
$credentials = require_once __DIR__ . '/credentials.php';

// --- PATHS ---
define('ROOT_DIR', dirname(__DIR__));
define('DATA_DIR', ROOT_DIR . '/data');
define('LOGS_DIR', DATA_DIR . '/logs');
define('CORE_DIR', ROOT_DIR . '/core');

// --- FILES ---
define('FILE_QUEUE', DATA_DIR . '/queue.csv'); // Pending Review
define('FILE_SEND_QUEUE', DATA_DIR . '/send_queue.csv'); // Ready to send
define('FILE_ARCHIVES', DATA_DIR . '/archives.csv');
define('FILE_SPAM', DATA_DIR . '/spam.csv'); // Mots-clés interdits
define('FILE_FACTURES', DATA_DIR . '/factures.csv'); // Emails de factures
define('FILE_SPAM_LOG', LOGS_DIR . '/spam_filter.log'); // Traceur de blocages
define('FILE_CLIENTS', DATA_DIR . '/clients.csv'); // Cache clients éventuel

// --- SETTINGS ---
define('ZIMBRA_PAUSE_SECONDS', 30);
define('SMTP_MAX_MAILS_PER_MINUTE', 2);
define('SMTP_PAUSE_BETWEEN_MAILS', 30); // 60s / 2 = 30s

// --- ZIMBRA TAGS ---
define('TAG_CLIENT_RECONNU', 'Yellow'); // Jaune
define('TAG_INTENTION_NOUVELLE', 'Red'); // Rouge
define('TAG_INTENTION_ERREUR', 'Green'); // Vert
define('TAG_PROBLEME_LIVRAISON', 'Blue'); // Bleu (Prioritaire)
define('TAG_UNKNOWN', 'Purple'); // Rose (A arbitrer)

// --- GLOBALS ---
// Exposition de la config via une classe statique ou global si besoin.
// Pour l'instant, on laisse les constantes faire le travail.

return $credentials; // Retourne les creds pour usage direct si besoin
