<?php
// scripts/test_final_tagging.php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/Logger.php';

// Redéfinition Logger pour ce test spécifique pour écrire dans imap_tagging.log
class TagLogger
{
    public static function log($msg)
    {
        $file = LOGS_DIR . '/imap_tagging.log';
        $entry = date('Y-m-d H:i:s') . " [TEST] " . $msg . PHP_EOL;
        echo $entry;
        file_put_contents($file, $entry, FILE_APPEND);
    }
}

TagLogger::log("--- DEBUT TEST FINAL TAGGING ---");

$creds = include __DIR__ . '/../config/credentials.php';
$server = "{" . $creds['email']['imap_host'] . ":993/imap/ssl}INBOX";
$user = $creds['email']['address'];
$pass = $creds['email']['password'];

TagLogger::log("Connexion IMAP à $server avec $user...");
$mbox = imap_open($server, $user, $pass);

if (!$mbox) {
    TagLogger::log("ERREUR CRITIQUE: " . imap_last_error());
    exit(1);
}

TagLogger::log("Connexion réussie.");

// Récupérer le dernier mail
$numMsgs = imap_num_msg($mbox);
if ($numMsgs == 0) {
    TagLogger::log("Aucun message dans INBOX.");
    imap_close($mbox);
    exit;
}

$lastMsgId = $numMsgs; // Msg No (pas UID pour ce test rapide, ou msg_no)
$header = imap_headerinfo($mbox, $lastMsgId);
TagLogger::log("Dernier Mail #$lastMsgId : " . $header->subject);

// TEST 1: Tag Textuel 'Rose'
$tagToTest = "Rose";
TagLogger::log("Tentative application Keyword: '$tagToTest' (via STORE +FLAGS)");

// Pause sécurité requise par user
TagLogger::log("PAUSE SECURITE 30s (Avant Tag)...");
sleep(30);

$res = imap_setflag_full($mbox, (string) $lastMsgId, $tagToTest);
if ($res) {
    TagLogger::log("Succès commande IMAP pour '$tagToTest'.");
} else {
    TagLogger::log("Echec commande IMAP: " . imap_last_error());
}

TagLogger::log("PAUSE SECURITE 30s (Après Tag)...");
sleep(30);


// TEST 2: Tag Label standard '$Label5' (Purple/Rose souvent)
$tagToTest2 = "\$Label5";
TagLogger::log("Tentative application Keyword: '$tagToTest2'");

TagLogger::log("PAUSE SECURITE 30s...");
sleep(30);

$res2 = imap_setflag_full($mbox, (string) $lastMsgId, $tagToTest2);
if ($res2) {
    TagLogger::log("Succès commande IMAP pour '$tagToTest2'.");
} else {
    TagLogger::log("Echec commande IMAP: " . imap_last_error());
}

TagLogger::log("Fin du test. Vérifiez Zimbra.");
imap_close($mbox);
?>