<?php
// scripts/init_csv.php
// Script utilitaire pour initialiser les fichiers vides

require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/CsvHandler.php';

$headersQueue = ['id', 'email', 'subject', 'date_received', 'tag_zimbra', 'grok_response', 'status', 'shop_id', 'client_id'];
$headersArchives = ['id', 'email', 'subject', 'date_sent', 'tag_zimbra', 'final_response', 'shop_id'];
// 'status' : PENDING, REVIEW_REQUIRED, APPROVED, SENT

// Initialisation file d'attente
if (!file_exists(FILE_QUEUE)) {
    $handle = fopen(FILE_QUEUE, 'w');
    fputcsv($handle, $headersQueue);
    fclose($handle);
    echo "✅ Created " . FILE_QUEUE . PHP_EOL;
}

// Initialisation archives
if (!file_exists(FILE_ARCHIVES)) {
    $handle = fopen(FILE_ARCHIVES, 'w');
    fputcsv($handle, $headersArchives);
    fclose($handle);
    echo "✅ Created " . FILE_ARCHIVES . PHP_EOL;
}

// Initialisation cache clients (optionnel)
if (!file_exists(FILE_CLIENTS)) {
    $handle = fopen(FILE_CLIENTS, 'w');
    fputcsv($handle, ['email', 'shop_id', 'customer_id', 'firstname', 'lastname']);
    fclose($handle);
    echo "✅ Created " . FILE_CLIENTS . PHP_EOL;
}
