<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/CsvHandler.php';

echo "--- DEBUG SPAM FILTER ---\n";
echo "FILE_SPAM: " . FILE_SPAM . "\n";

$spamKeywords = [];
if (file_exists(FILE_SPAM)) {
    $rows = array_map('str_getcsv', file(FILE_SPAM));
    $header = array_shift($rows);
    echo "Spam CSV Header: " . implode(',', $header) . "\n";
    foreach ($rows as $r) {
        if (!empty($r[0])) {
            $kw = strtolower(trim($r[0]));
            $spamKeywords[] = $kw;
            echo "Loaded Keyword: '$kw'\n";
        }
    }
} else {
    echo "FILE_SPAM NOT FOUND!\n";
}

$fullQueue = CsvHandler::read(FILE_QUEUE);
echo "Queue size: " . count($fullQueue) . "\n";

$found = 0;
foreach ($fullQueue as $item) {
    if (($item['status'] ?? '') === 'SPAM_SUSPECT') {
        $fields = [
            $item['subject'] ?? '',
            $item['email'] ?? '',
            $item['sender_name'] ?? '',
            $item['body'] ?? '',
            $item['grok_response'] ?? ''
        ];
        $haystack = strtolower(implode(' ', $fields));
        
        $match = false;
        $matchedKw = '';
        foreach ($spamKeywords as $kw) {
            if ($kw !== '' && strpos($haystack, $kw) !== false) {
                $match = true;
                $matchedKw = $kw;
                break;
            }
        }
        
        if ($match) {
            $found++;
            echo "MATCH FOUND - ID: {$item['id']} | Keyword: '$matchedKw' | Email: " . ($item['email'] ?? '') . "\n";
        } else {
            // Log one non-match to see why it fails
            if (strpos(strtolower($item['email'] ?? ''), 'wordpress') !== false) {
                 echo "FAIL - ID: {$item['id']} contains 'wordpress' in email but NOT MATCHED! Haystack: " . substr($haystack, 0, 100) . "...\n";
            }
        }
    }
}

echo "Total WordPress/Spam items still in Suspicion: $found\n";
