<?php
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/nav.php';
?>

<div class="card shadow">
    <div class="card-header d-flex justify-content-between align-items-center">
        <span>Gestion des Tags & Couleurs</span>
        <button class="btn btn-primary" onclick="retagQueue()" id="btn-retag">FORCE RE-TAG (Max 2 mails)</button>
    </div>
    <div class="card-body">
        <div class="alert alert-info">
            Si les couleurs n'apparaissent pas dans Zimbra, utilisez le bouton ci-dessus pour forcer
            l'application des tags sur les mails en attente.
            <br><strong>Note :</strong> Traitement long (60s par mail) pour éviter le blocage.
        </div>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th>Tag Interne</th>
                    <th>Label Zimbra</th>
                    <th>Signification</th>
                    <th>Aperçu</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>Yellow</td>
                    <td>$Label2</td>
                    <td>Client Reconnu</td>
                    <td><span class="badge tag-Yellow p-2">Yellow</span></td>
                </tr>
                <tr>
                    <td>Red</td>
                    <td>$Label1</td>
                    <td>Nouvelle Commande / Devis</td>
                    <td><span class="badge tag-Red p-2">Red</span></td>
                </tr>
                <tr>
                    <td>Green</td>
                    <td>$Label3</td>
                    <td>Erreur Commande</td>
                    <td><span class="badge tag-Green p-2">Green</span></td>
                </tr>
                <tr>
                    <td>Blue</td>
                    <td>$Label4</td>
                    <td>Problème Livraison (Prio)</td>
                    <td><span class="badge tag-Blue p-2">Blue</span></td>
                </tr>
                <tr>
                    <td>Purple</td>
                    <td>$Label5</td>
                    <td>Inconnu / Spam Suspect</td>
                    <td><span class="badge tag-Purple p-2">Purple</span></td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<script>
    function retagQueue() {
        const btn = document.getElementById('btn-retag');
        const originalText = btn.innerHTML;

        if (!confirm("⚠️ Attention : Recalculer les tags sur Zimbra ?\nCela prendra du temps (max 2 mails par clic).")) return;

        btn.disabled = true;
        btn.innerHTML = '⏳ Traitement en cours...';

        fetch('action.php?action=retag_queue')
            .then(r => r.json())
            .then(data => {
                alert(data.message || 'Fait');
                btn.disabled = false;
                btn.innerHTML = originalText;
            })
            .catch(err => {
                alert("Erreur / Timeout réseau.");
                btn.disabled = false;
                btn.innerHTML = originalText;
            });
    }
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>