<?php
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/nav.php';
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/CsvHandler.php';

$queue = CsvHandler::read(FILE_QUEUE);
$payplugMessages = array_filter($queue, fn($item) => $item['status'] === 'PAYPLUG_AUTO');
?>

<div class="card shadow">
    <div class="card-header bg-info text-white">
        <h5 class="mb-0">📧 Messages Automatiques Payplug</h5>
        <small>Messages automatiques de support@payplug.com (Aucune réponse nécessaire)</small>
    </div>
    <div class="card-body">
        <?php if (empty($payplugMessages)): ?>
            <div class="alert alert-success">
                <i class="bi bi-check-circle"></i> Aucun message Payplug en attente.
            </div>
        <?php else: ?>
            <div class="alert alert-info">
                <strong>
                    <?= count($payplugMessages) ?>
                </strong> message(s) automatique(s) Payplug détecté(s).
            </div>
            
            <div class="mb-3">
                <button class="btn btn-success" onclick="markAllAsRead()">
                    ✅ Marquer tous comme lus
                </button>
            </div>

            <div class="table-responsive" style="max-height: 600px; overflow-y: auto;">
                <table class="table table-hover table-sm">
                    <thead class="table-info sticky-top">
                        <tr>
                            <th style="width: 10%;">ID</th>
                            <th style="width: 15%;">Date</th>
                            <th style="width: 25%;">De</th>
                            <th style="width: 40%;">Sujet</th>
                            <th style="width: 10%;">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($payplugMessages as $item): ?>
                            <tr>
                                <td><code><?= htmlspecialchars($item['id']) ?></code></td>
                                <td>
                                    <?= htmlspecialchars($item['date']) ?>
                                </td>
                                <td class="text-truncate" style="max-width: 200px;">
                                    <?= htmlspecialchars($item['from']) ?>
                                </td>
                                <td class="text-truncate" style="max-width: 300px;">
                                    <strong>
                                        <?= htmlspecialchars($item['subject']) ?>
                                    </strong>
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-outline-secondary" onclick="viewEmail('<?= $item['id'] ?>')">
                                        👁️ Voir
                                    </button>
                                </td>
                            </tr>
                            <!-- Hidden data for modal -->
                            <div id="body-<?= $item['id'] ?>" style="display:none;">
                                <?= htmlspecialchars($item['body']) ?>
                            </div>
                            <div id="from-<?= $item['id'] ?>" style="display:none;">
                                <?= htmlspecialchars($item['from']) ?>
                            </div>
                            <div id="subject-<?= $item['id'] ?>" style="display:none;">
                                <?= htmlspecialchars($item['subject']) ?>
                            </div>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<script>
function markAllAsRead() {
    // Get all Payplug message IDs from the page
    const ids = [];
    document.querySelectorAll('tbody tr').forEach(row => {
        const codeElement = row.querySelector('code');
        if (codeElement) {
            ids.push(codeElement.textContent.trim());
        }
    });
    
    if (ids.length === 0) {
        alert('Aucun message à marquer.');
        return;
    }
    
    if (!confirm(`Marquer ${ids.length} message(s) comme lus dans Zimbra ?`)) return;
    
    let completed = 0;
    let errors = 0;
    
    // Mark each message as read
    ids.forEach((id, index) => {
        fetch('action.php?action=mark_as_read&id=' + id)
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    completed++;
                } else {
                    errors++;
                }
                
                // When all done, show result and reload
                if (completed + errors === ids.length) {
                    if (errors === 0) {
                        alert(`✅ ${completed} message(s) marqué(s) comme lus !`);
                    } else {
                        alert(`⚠️ ${completed} réussi(s), ${errors} erreur(s)`);
                    }
                    location.reload();
                }
            })
            .catch(e => {
                errors++;
                if (completed + errors === ids.length) {
                    alert(`⚠️ ${completed} réussi(s), ${errors} erreur(s)`);
                    location.reload();
                }
            });
    });
}
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>