<?php
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/nav.php';
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/CsvHandler.php';
require_once __DIR__ . '/../core/ImapClient.php';

$fullQueue = CsvHandler::read(FILE_QUEUE);

require_once __DIR__ . '/../core/SpamFilter.php';

// 1. Sync Unread UIDs
$unreadUids = isset($GLOBALS['globalUnreadUids']) ? $GLOBALS['globalUnreadUids'] : [];
if (empty($unreadUids)) {
    try {
        $imap = new ImapClient();
        $unreadUids = $imap->getUnreadUids();
        $imap->close();
    } catch (Exception $e) {
        $unreadUids = []; // Fallback
    }
}

// 2. Filter Main Queue (Exclude Spam, Suspicion, and Payplug)
$activeQueue = array_filter($fullQueue, function ($item) use ($unreadUids) {
    // Exclude Payplug automatic messages
    if (($item['status'] ?? '') === 'PAYPLUG_AUTO') {
        return false;
    }

    if (SpamFilter::getTargetTab($item) !== 'PENDING') {
        return false;
    }

    if (empty($unreadUids))
        return true;
    return in_array($item['id'], $unreadUids);
});

// 4. SORT BY DATE DESC (Newest First)
usort($activeQueue, function ($a, $b) {
    return strtotime($b['date_received']) <=> strtotime($a['date_received']);
});


function renderMainTable($data)
{
    if (empty($data)) {
        echo '<div class="text-center py-5 text-muted">Aucun mail en attente (Non lu).</div>';
        return;
    }
    echo '<div class="table-responsive">';
    echo '<table class="table table-hover table-sm mb-0 align-middle" style="font-size: 0.9rem;">';
    echo '<thead class="table-light"><tr><th>NBR</th><th>ID</th><th>Date</th><th style="max-width: 250px;">Client / Sujet</th><th>Tag</th><th>Info (Aperçu)</th><th class="text-end">Actions</th></tr></thead>';
    echo '<tbody>';
    $count = 1;
    foreach ($data as $item) {
        $id = $item['id'];
        $ts = strtotime($item['date_received']);
        $isRecent = (time() - $ts) < (15 * 86400); // 15 days
        $dateStyle = $isRecent ? 'color: #ff4444; font-weight: bold;' : '';

        echo "<tr id='row-$id'>";
        echo "<td class='text-muted small'>$count</td>";
        echo "<td class='text-muted small'>#$id</td>";
        echo "<td class='small text-nowrap' style='$dateStyle'>" . date('d-m H:i', $ts) . "</td>";
        $count++;

        $sub = $item['subject'];
        if (strlen($sub) > 40)
            $sub = substr($sub, 0, 40) . '...';
        echo "<td style='max-width: 250px; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;'>";
        echo "<strong>" . htmlspecialchars($item['email']) . "</strong><br><small class='text-muted'>" . htmlspecialchars($sub) . "</small></td>";

        echo "<td><span class='badge tag-" . ($item['tag_zimbra'] ?? 'Default') . " p-1'>" . ($item['tag_zimbra'] ?? '?') . "</span></td>";

        $info = $item['grok_response'] ?? '';
        if (strlen($info) > 30)
            $info = substr($info, 0, 30) . '...';
        echo "<td><small class='text-muted'>" . htmlspecialchars($info) . "</small></td>";

        echo "<td class='text-end'>";
        echo "<div class='btn-group api-actions'>";
        echo "<button class='btn btn-danger btn-sm me-1' onclick=\"performAction('trash', '$id')\">⛔ Spam</button>";
        echo "<button class='btn btn-primary btn-sm me-1' onclick=\"viewDraft('$id')\">🤖 Rép. IA</button>";
        echo "<button class='btn btn-info btn-sm text-white me-1' onclick=\"viewEmail('$id')\">👀 Voir Msg</button>";
        echo "<button class='btn btn-success btn-sm' onclick=\"performAction('accept', '$id')\">✅ Envoyer</button>";
        echo "<button class='btn btn-warning btn-sm ms-1 dropdown-toggle' data-bs-toggle='dropdown'>Reclasser</button>";
        echo "<ul class='dropdown-menu'>";
        foreach (['Yellow' => 'Client', 'Red' => 'Cmd', 'Green' => 'Erreur', 'Blue' => 'Livraison'] as $t => $l) {
            echo "<li><a class='dropdown-item' href='#' onclick=\"performAction('reclassify', '$id', '$t')\">$l</a></li>";
        }
        echo "</ul>";
        echo "</div>";
        echo "<div class='loader text-primary' id='loader-$id'><div class='spinner-border spinner-border-sm'></div></div>";

        // Hidden Data for Modals
        echo "<div id='body-$id' style='display:none'>" . htmlspecialchars($item['body'] ?? '(Vide)') . "</div>";
        echo "<div id='draft-$id' style='display:none'>" . htmlspecialchars($item['grok_response'] ?? '(Pas de brouillon généré)') . "</div>";

        echo "</td></tr>";
    }
    echo '</tbody></table></div>';
}
?>

<div class="card shadow border-0">
    <div class="card-body p-0">
        <?php renderMainTable($activeQueue); ?>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>