<?php
// public/includes/nav.php
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../core/CsvHandler.php';
require_once __DIR__ . '/../../core/ImapClient.php';
$navUnreadUids = [];
try {
    $imapNav = new ImapClient();
    $navUnreadUids = $imapNav->getUnreadUids();
    $imapNav->close();
} catch (Exception $e) { $navUnreadUids = []; }
$GLOBALS['globalUnreadUids'] = $navUnreadUids;
require_once __DIR__ . '/../../core/SpamFilter.php';
$fullNavQueue = CsvHandler::read(FILE_QUEUE);
$countPending = 0; $countSuspicion = 0; $countSpam = 0; $countPayplug = 0; $countFactures = 0;
foreach ($fullNavQueue as $item) {
    $uid = $item['id'];
    if (!in_array($uid, $navUnreadUids)) continue;
    $tab = SpamFilter::getTargetTab($item);
    if ($tab === 'SPAM') $countSpam++;
    elseif ($tab === 'SUSPICION') $countSuspicion++;
    elseif (($item['status'] ?? '') === 'PAYPLUG_AUTO') $countPayplug++;
    elseif (($item['status'] ?? '') === 'FACTURE_AUTO') $countFactures++;
    else $countPending++;
}
$current_page = basename($_SERVER['PHP_SELF']);
?>
<ul class="nav nav-tabs mb-3">
    <li class="nav-item"><a class="nav-link <?php echo ($current_page == 'index.php') ? 'active' : ''; ?>" href="index.php">📩 En Attente (<?php echo $countPending; ?>)</a></li>
    <li class="nav-item"><a class="nav-link text-danger <?php echo ($current_page == 'suspicion.php') ? 'active' : ''; ?>" href="suspicion.php">⚠️ Suspicion IA (<?php echo $countSuspicion; ?>)</a></li>
    <li class="nav-item"><a class="nav-link <?php echo ($current_page == 'spam.php') ? 'active' : ''; ?>" href="spam.php">🛑 Spam (<?php echo $countSpam; ?>)</a></li>
    <li class="nav-item"><a class="nav-link text-primary <?php echo ($current_page == 'tags.php') ? 'active' : ''; ?>" href="tags.php">🏷️ Tags Zimbra</a></li>
    <li class="nav-item"><a class="nav-link text-info <?php echo ($current_page == 'payplug.php') ? 'active' : ''; ?>" href="payplug.php">�� Payplug (<?php echo $countPayplug; ?>)</a></li>
    <li class="nav-item"><a class="nav-link text-secondary <?php echo ($current_page == 'factures.php') ? 'active' : ''; ?>" href="factures.php">🧾 Factures (<?php echo $countFactures; ?>)</a></li>
</ul>
