<!DOCTYPE html>
<html lang="fr" data-bs-theme="dark">

<head>
    <meta charset="UTF-8">
    <title>Grok Mail Bot</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=JetBrains+Mono:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'JetBrains Mono', 'Consolas', monospace;
            background-color: #0d0d0d !important;
            color: #00ff41;
        }

        /* Geek / Terminal Look */
        .card {
            background-color: #111;
            border: 1px solid #333;
        }

        .card-header {
            background-color: #1a1a1a;
            border-bottom: 1px solid #333;
            color: #00ff41;
            font-weight: bold;
        }

        .table {
            color: #ccc;
            border-color: #333;
        }

        .table-hover tbody tr:hover {
            color: #fff;
            background-color: #222;
        }

        .modal-content {
            background-color: #111;
            border: 1px solid #00ff41;
        }

        .modal-header,
        .modal-footer {
            border-color: #333;
        }

        /* Tags (Adjusted for Dark Mode) */
        .tag-Yellow {
            background-color: #b39b00;
            color: #000;
        }

        .tag-Red {
            background-color: #5c0000;
            color: #ff9999;
            border: 1px solid #ff0000;
        }

        .tag-Green {
            background-color: #0f5132;
            color: #d1e7dd;
        }

        .tag-Blue {
            background-color: #003366;
            color: #9ec5fe;
            border-left: 5px solid #0d6efd;
        }

        .tag-Purple {
            background-color: #3d004e;
            color: #e0cffc;
            border: 1px solid #6f42c1;
        }

        /* Buttons */
        .btn-primary {
            background-color: #006400;
            border-color: #00ff41;
            color: #fff;
        }

        .btn-primary:hover {
            background-color: #008000;
            border-color: #00ff41;
        }

        .btn-outline-secondary {
            color: #888;
            border-color: #444;
        }

        .loader {
            display: none;
        }

        /* Scrollbar */
        ::-webkit-scrollbar {
            width: 10px;
        }

        ::-webkit-scrollbar-track {
            background: #111;
        }

        ::-webkit-scrollbar-thumb {
            background: #333;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: #555;
        }
    </style>
</head>

<body class="bg-dark text-success">

    <div class="container mt-4">
        <div class="d-flex justify-content-between align-items-center mb-2">
            <h2>🤖 Grok Mail Responder <small class="text-muted text-sm" style="font-size:0.6em">Zimbra / Presta /
                    AI</small></h2>
            <div>
                <button id="btn-force-update" class="btn btn-outline-success btn-sm me-2"
                    style="font-family: 'JetBrains Mono', monospace; border-width: 2px; text-transform: uppercase; letter-spacing: 1px; box-shadow: 0 0 10px #00ff41;"
                    onclick="forceUpdate()">[ 🚀 FORCE_SYNC ]</button>

                <button class="btn btn-outline-danger btn-sm me-2" onclick="emptyTrash()" id="btn-trash">🗑️ Vider
                    Corbeille (Expunge)</button>
                <button class="btn btn-outline-secondary btn-sm" onclick="location.reload()">🔄 Refresh</button>
            </div>
        </div>

        <!-- LEGEND -->
        <div class="mb-4 d-flex gap-3 align-items-center" style="font-size: 1.7rem;">
            <span class="text-muted me-2">Légende :</span>
            <span class="badge tag-Yellow p-2">Client</span>
            <span class="badge tag-Red p-2">Commande</span>
            <span class="badge tag-Green p-2">Erreur</span>
            <span class="badge tag-Blue p-2">Livraison</span>
            <span class="badge tag-Purple p-2">Spam/Inconnu</span>
        </div>

        <script>
            function forceUpdate() {
                const btn = document.getElementById('btn-force-update');
                btn.className = "btn btn-danger btn-sm me-2";
                btn.innerHTML = "[ ⏳ STARTING... ]";
                btn.disabled = true;

                fetch('action.php?action=force_scan')
                    .then(r => r.json())
                    .then(data => {
                        if (data.success) {
                            pollScanStatus();
                        } else {
                            alert('Erreur: ' + data.message);
                            resetSyncButton();
                        }
                    })
                    .catch(e => {
                        alert('Erreur: ' + e);
                        resetSyncButton();
                    });
            }

            function resetSyncButton() {
                const btn = document.getElementById('btn-force-update');
                if (!btn) return;
                btn.className = "btn btn-outline-success btn-sm me-2";
                btn.innerHTML = "[ 🚀 FORCE_SYNC ]";
                btn.disabled = false;
                btn.style.boxShadow = "0 0 10px #00ff41";
            }

            function setSyncButtonRunning() {
                const btn = document.getElementById('btn-force-update');
                if (!btn) return;
                btn.className = "btn btn-danger btn-sm me-2";
                btn.innerHTML = "[ ⏳ SCANNING... ]";
                btn.disabled = true;
                btn.style.boxShadow = "0 0 10px #ff0000";
            }

            function pollScanStatus() {
                setSyncButtonRunning();

                if (window.scanPoller) clearInterval(window.scanPoller);
                window.scanPoller = setInterval(() => {
                    fetch('action.php?action=check_scan_status')
                        .then(r => r.json())
                        .then(data => {
                            if (data.success && data.running) {
                                setSyncButtonRunning();
                            } else {
                                clearInterval(window.scanPoller);
                                resetSyncButton();
                                location.reload();
                            }
                        })
                        .catch(e => console.error(e));
                }, 5000);
            }

            document.addEventListener('DOMContentLoaded', () => {
                fetch('action.php?action=check_scan_status')
                    .then(r => r.json())
                    .then(data => {
                        if (data.success && data.running) {
                            pollScanStatus();
                        }
                    });
            });

            function emptyTrash() {
                if (!confirm('Vider la corbeille Zimbra définitivement ?')) return;

                const btn = document.getElementById('btn-trash');
                const originalText = btn.innerHTML;
                btn.innerHTML = "⏳ Vidage...";
                btn.disabled = true;

                fetch('action.php?action=expunge')
                    .then(response => response.json())
                    .then(data => {
                        alert(data.message);
                        btn.innerHTML = originalText;
                        btn.disabled = false;
                    })
                    .catch(error => {
                        alert('Erreur communication');
                        console.error(error);
                        btn.innerHTML = originalText;
                        btn.disabled = false;
                    });
            }
        </script>