<?php
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/nav.php';
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/CsvHandler.php';
?>

<div class="card shadow">
    <div class="card-header bg-dark text-white">
        <h5 class="mb-0">📄 Gestion des Factures</h5>
        <small class="text-white-50">Ajouter des adresses email de factures pour les marquer et déplacer automatiquement</small>
    </div>
    <div class="card-body">
        
        <!-- Add Email Form -->
        <div class="card mb-4">
            <div class="card-header bg-secondary text-white">
                <strong>➕ Ajouter une adresse email de facture</strong>
            </div>
            <div class="card-body">
                <div class="input-group">
                    <input type="email" class="form-control" id="new-facture-email" 
                           placeholder="exemple: factures@entreprise.com">
                    <button class="btn btn-primary" onclick="addFactureEmail()">
                        ➕ Ajouter
                    </button>
                </div>
            </div>
        </div>

        <!-- Email List -->
        <div class="card mb-4">
            <div class="card-header bg-secondary text-white">
                <strong>📧 Liste des emails de factures enregistrés</strong>
            </div>
            <div class="card-body">
                <ul id="facture-email-list" class="list-group">
                    <!-- Loaded via JS -->
                </ul>
            </div>
        </div>

        <!-- Process Button -->
        <div class="card">
            <div class="card-header bg-dark text-white border-warning">
                <strong class="text-warning">⚙️ Traiter les factures</strong>
            </div>
            <div class="card-body">
                <p class="mb-3">
                    Cette action va chercher tous les messages non lus provenant des adresses enregistrées ci-dessus, 
                    les marquer comme lus et les déplacer dans <code>inbox/Factures</code> sur Zimbra.
                </p>
                <button class="btn btn-success btn-lg" onclick="processFactures()">
                    ✅ Marquer comme lus et déplacer
                </button>
                <div id="process-result" class="mt-3"></div>
            </div>
        </div>

    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', () => {
    loadFactureEmails();
});

function loadFactureEmails() {
    fetch('action.php?action=get_facture_emails')
        .then(r => r.json())
        .then(data => {
            const list = document.getElementById('facture-email-list');
            if (data.success && data.emails.length > 0) {
                list.innerHTML = data.emails.map(email => `
                    <li class="list-group-item d-flex justify-content-between align-items-center">
                        <span>${email}</span>
                        <button class="btn btn-sm btn-danger" onclick="removeFactureEmail('${email}')">
                            🗑️ Supprimer
                        </button>
                    </li>
                `).join('');
            } else {
                list.innerHTML = '<li class="list-group-item text-muted">Aucune adresse enregistrée</li>';
            }
        })
        .catch(e => {
            console.error(e);
            alert('Erreur lors du chargement des emails: ' + e);
        });
}

function addFactureEmail() {
    const input = document.getElementById('new-facture-email');
    const email = input.value.trim();
    
    if (!email) {
        alert('Veuillez entrer une adresse email');
        return;
    }
    
    // Basic email validation
    if (!email.includes('@')) {
        alert('Adresse email invalide');
        return;
    }
    
    const formData = new FormData();
    formData.append('email', email);
    
    fetch('action.php?action=add_facture_email', {
        method: 'POST',
        body: formData
    })
    .then(r => r.json())
    .then(data => {
        if (data.success) {
            input.value = '';
            alert('✅ Email ajouté avec succès');
            loadFactureEmails();
        } else {
            alert('❌ Erreur: ' + (data.message || 'Erreur inconnue'));
        }
    })
    .catch(e => {
        alert('❌ Erreur réseau: ' + e);
    });
}

function removeFactureEmail(email) {
    if (!confirm(`Supprimer l'email: ${email} ?`)) return;
    
    const formData = new FormData();
    formData.append('email', email);
    
    fetch('action.php?action=remove_facture_email', {
        method: 'POST',
        body: formData
    })
    .then(r => r.json())
    .then(data => {
        if (data.success) {
            alert('✅ Email supprimé');
            loadFactureEmails();
        } else {
            alert('❌ Erreur: ' + (data.message || 'Erreur inconnue'));
        }
    })
    .catch(e => {
        alert('❌ Erreur réseau: ' + e);
    });
}

function processFactures() {
    if (!confirm('Traiter toutes les factures (marquer lues + déplacer) ?')) return;
    
    const resultDiv = document.getElementById('process-result');
    resultDiv.innerHTML = '<div class="alert alert-info">⏳ Traitement en cours...</div>';
    
    fetch('action.php?action=process_factures')
        .then(r => r.json())
        .then(data => {
            if (data.success) {
                resultDiv.innerHTML = `
                    <div class="alert alert-success">
                        <strong>✅ Traitement terminé !</strong><br>
                        ${data.processed || 0} message(s) traité(s)<br>
                        ${data.moved || 0} message(s) déplacé(s) dans inbox/Factures
                    </div>
                `;
            } else {
                resultDiv.innerHTML = `
                    <div class="alert alert-danger">
                        ❌ Erreur: ${data.message || 'Erreur inconnue'}
                    </div>
                `;
            }
        })
        .catch(e => {
            resultDiv.innerHTML = `
                <div class="alert alert-danger">
                    ❌ Erreur réseau: ${e}
                </div>
            `;
        });
}
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>