<?php
// core/PrestaShop.php

require_once __DIR__ . '/Logger.php';

class PrestaShop
{
    private $shops;

    public function __construct()
    {
        $creds = require __DIR__ . '/../config/credentials.php';
        $this->shops = $creds['prestashop'];
    }

    /**
     * Cherche un client par email sur toutes les boutiques.
     * @param string $email
     * @return array|null Info client + shop_id ou null
     */
    public function searchClient(string $email)
    {
        foreach ($this->shops as $id => $shop) {
            $url = rtrim($shop['url'], '/') . '/api/customers';
            $key = $shop['key'];

            // Construction URL avec filtre
            $queryUrl = $url . "?filter[email]=" . urlencode($email) . "&display=[id,firstname,lastname,email]&output_format=JSON";

            // Contexte HTTP pour Auth Basic
            $context = stream_context_create([
                'http' => [
                    'header' => "Authorization: Basic " . base64_encode($key . ":")
                ]
            ]);

            try {
                $response = @file_get_contents($queryUrl, false, $context);

                if ($response === false) {
                    Logger::debug("PrestaShop $id ({$shop['name']}) : Pas de réponse ou erreur.");
                    continue;
                }

                $json = json_decode($response, true);

                if (isset($json['customers']) && !empty($json['customers'])) {
                    // Client trouvé !
                    $customer = $json['customers'][0];
                    Logger::info("Client trouvé sur Shop $id ({$shop['name']}) : ID " . $customer['id']);

                    return [
                        'shop_id' => $id,
                        'shop_name' => $shop['name'],
                        'customer' => $customer
                    ];
                }

            } catch (Exception $e) {
                Logger::error("Erreur PrestaShop $id : " . $e->getMessage());
            }
        }

        return null;
    }
}
