<?php
// core/Logger.php

class Logger
{
    public static function log(string $message, string $level = 'INFO')
    {
        $date = date('Y-m-d');
        $time = date('H:i:s');
        $logFile = LOGS_DIR . "/app_$date.log";

        $formattedMessage = "[$date $time] [$level] $message" . PHP_EOL;

        // Pas besoin de CsvHandler ici, un simple append suffira mais avec flock quand même
        file_put_contents($logFile, $formattedMessage, FILE_APPEND | LOCK_EX);
    }

    public static function error(string $message)
    {
        self::log($message, 'ERROR');
    }

    public static function info(string $message)
    {
        self::log($message, 'INFO');
    }

    public static function debug(string $message)
    {
        self::log($message, 'DEBUG');
    }
}
