<?php
// core/CsvHandler.php
class CsvHandler {
    public static function read(string $filepath): array {
        if (!file_exists($filepath)) return [];
        $handle = fopen($filepath, "r");
        if (!$handle) return [];
        $data = [];
        if (flock($handle, LOCK_SH)) {
            $headers = fgetcsv($handle);
            if ($headers) {
                while (($row = fgetcsv($handle)) !== false) {
                    if (count($row) < count($headers)) $row = array_pad($row, count($headers), "");
                    if (count($headers) === count($row)) $data[] = array_combine($headers, $row);
                    else $data[] = $row;
                }
            }
            flock($handle, LOCK_UN);
        }
        fclose($handle);
        return $data;
    }
    public static function append(string $filepath, array $data): bool {
        $isNew = !file_exists($filepath);
        $handle = fopen($filepath, "a");
        if (!$handle) return false;
        $success = false;
        if (flock($handle, LOCK_EX)) {
            if ($isNew) fputcsv($handle, array_keys($data));
            fputcsv($handle, $data);
            fflush($handle);
            flock($handle, LOCK_UN);
            $success = true;
        }
        fclose($handle);
        return $success;
    }
    public static function overwrite(string $filepath, array $allData, array $headers = []): bool {
        $handle = fopen($filepath, "w");
        if (!$handle) return false;
        $success = false;
        if (flock($handle, LOCK_EX)) {
            if (empty($headers) && !empty($allData)) $headers = array_keys($allData[0]);
            if (!empty($headers)) fputcsv($handle, $headers);
            foreach ($allData as $row) fputcsv($handle, $row);
            fflush($handle);
            flock($handle, LOCK_UN);
            $success = true;
        }
        fclose($handle);
        return $success;
    }
}
