<?php
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/ImapClient.php';
require_once __DIR__ . '/../core/Logger.php';

echo "--- START TEST ---" . PHP_EOL;
try {
    $imap = new ImapClient();
    echo "Connected." . PHP_EOL;
    
    echo "Fetching 5 Unread..." . PHP_EOL;
    $mails = $imap->fetchUnread(5);
    
    echo "Count: " . count($mails) . PHP_EOL;
    foreach ($mails as $m) {
        echo " - UID: " . $m['uid'] . " | From: " . $m['from'] . " | Name: " . ($m['from_name'] ?? 'N/A') . PHP_EOL;
    }
    
    $imap->close();
    echo "Closed." . PHP_EOL;
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . PHP_EOL;
}
echo "--- END TEST ---" . PHP_EOL;
