<?php
require_once __DIR__ . '/../core/CsvHandler.php';
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/Logger.php';

Logger::info("--- START DEDUPLICATION ---");

$queue = CsvHandler::read(FILE_QUEUE);
$countBefore = count($queue);

$unique = [];
foreach ($queue as $item) {
    // Key by ID. Later entries overwrite earlier ones (assuming append order).
    // Or we case use ID as key.
    $id = $item['id'];
    if (empty($id))
        continue;
    $unique[$id] = $item;
}

$countAfter = count($unique);
$removed = $countBefore - $countAfter;

if ($removed > 0) {
    Logger::info("Found $removed duplicates. optimizing...");
    CsvHandler::overwrite(FILE_QUEUE, array_values($unique));
    echo "Deduplication Complete: Removed $removed duplicates.\n";
} else {
    echo "No duplicates found.\n";
}

Logger::info("--- END DEDUPLICATION ---");
