<?php
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/nav.php';
require_once __DIR__ . '/../config/config.php';
require_once __DIR__ . '/../core/CsvHandler.php';
require_once __DIR__ . '/../core/ImapClient.php';

$fullQueue = CsvHandler::read(FILE_QUEUE);
$unreadUids = isset($GLOBALS['globalUnreadUids']) ? $GLOBALS['globalUnreadUids'] : [];
require_once __DIR__ . '/../core/SpamFilter.php';


$spamQueue = array_filter($fullQueue, function ($item) use ($unreadUids) {
    if (SpamFilter::getTargetTab($item) !== 'SUSPICION') {
        return false;
    }

    // Sync Filter
    if (!empty($unreadUids)) {
        return in_array($item['id'], $unreadUids);
    }
    return true;
});

// Sort by Date Desc
usort($spamQueue, function ($a, $b) {
    return strtotime($b['date_received']) <=> strtotime($a['date_received']);
});


function renderSpamTable($data)
{
    if (empty($data)) {
        echo '<div class="text-center py-5 text-muted">Aucune suspicion de spam.</div>';
        return;
    }
    echo '<div class="table-responsive">';
    echo '<table class="table table-hover table-sm mb-0 align-middle" style="font-size: 0.9rem;">';
    echo '<thead class="table-light"><tr><th>NBR</th><th>ID</th><th>Date</th><th style="max-width: 250px;">Client / Sujet</th><th>Tag</th><th>Actions</th></tr></thead>';
    echo '<tbody>';
    $count = 1;
    foreach ($data as $item) {
        $id = $item['id'];
        echo "<tr id='row-$id'>";
        echo "<td class='text-muted small'>$count</td>";
        echo "<td class='text-muted small'>#$id</td>";
        echo "<td class='small text-nowrap'>" . date('d-m H:i', strtotime($item['date_received'])) . "</td>";
        $count++;

        $sub = $item['subject'];
        if (strlen($sub) > 40)
            $sub = substr($sub, 0, 40) . '...';

        echo "<td style='max-width: 250px; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;'>";
        echo "<strong>" . htmlspecialchars($item['email']) . "</strong><br><small class='text-muted'>" . htmlspecialchars($sub) . "</small></td>";
        echo "<td><span class='badge tag-" . ($item['tag_zimbra'] ?? 'Default') . " p-1'>" . ($item['tag_zimbra'] ?? '?') . "</span></td>";

        echo "<td class='text-end'>";
        echo "<div class='btn-group api-actions'>";
        echo "<button class='btn btn-success btn-sm' onclick=\"performAction('reclassify', '$id', 'Yellow')\">✅ Valider</button>";
        echo "<button class='btn btn-danger btn-sm ms-1' onclick=\"performAction('trash', '$id')\">🗑️ Spam</button>";
        echo "</div>";
        echo "<div class='loader text-primary' id='loader-$id'><div class='spinner-border spinner-border-sm'></div></div>";
        echo "</td></tr>";
    }
    echo '</tbody></table></div>';
}
?>

<div class="alert alert-warning">
    Ces messages ont été marqués comme <strong>Spam</strong> par l'IA. Vérifiez avant de supprimer.
</div>
<div class="card shadow border-0 border-danger">
    <div class="card-body p-0">
        <?php renderSpamTable($spamQueue); ?>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>