<?php
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/nav.php';
?>

<div class="card shadow">
    <div class="card-header">Gérer les mots-clés interdits (Filtre CSV)</div>
    <div class="card-body">
        <div class="input-group mb-3">
            <input type="text" class="form-control" id="new-keyword"
                placeholder="Nouveau mot ou expression (ex: bitcoin)">
            <button class="btn btn-primary" type="button" onclick="addKeyword()">Ajouter</button>
        </div>

        <h4 class="mt-4">Liste actuelle :</h4>

        <ul id="keyword-list" class="list-group mb-4">
            <!-- Loaded via JS -->
        </ul>

        <h5 class="text-danger mt-4">🔍 Mails détectés (Prêts à être supprimés) :</h5>

        <button class="btn btn-warning mb-3" onclick="cleanSpamByKeywords()">⚠️ Envoyer vers Corbeille
            (Appliquer Filtres)</button>

        <div id="spam-preview-container" class="border rounded p-2"
            style="max-height: 300px; overflow-y: auto; background:#222;">
            <table class="table table-dark table-sm table-striped">
                <thead>
                    <tr>
                        <th>NBR</th>
                        <th>ID</th>
                        <th>Expéditeur</th>
                        <th>Sujet</th>
                        <th>Mot-clé</th>
                    </tr>
                </thead>
                <tbody id="spam-preview-body">
                    <tr>
                        <td colspan="5" class="text-center text-muted">Chargement...</td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        loadKeywords();
        setTimeout(loadSpamPreview, 500);
    });

    let isScanning = false;

    function loadSpamPreview() {
        if (isScanning) return;
        isScanning = true;

        const list = document.getElementById('keyword-list');
        const tbody = document.getElementById('spam-preview-body');
        if (!tbody) return;

        // SHOW PROGRESS BAR
        let bar = document.getElementById('scan-progress-li');
        if (!bar && list) {
            bar = document.createElement('li');
            bar.id = 'scan-progress-li';
            bar.className = 'list-group-item p-0 border-0 mb-2';
            bar.innerHTML = `
            <div class="progress" style="height: 30px; border-radius: 5px;">
                <div class="progress-bar progress-bar-striped progress-bar-animated bg-warning text-dark fw-bold" 
                     role="progressbar" style="width: 100%; font-size: 1.1em;">
                    ⏳ Analyse Local en cours...
                </div>
            </div>`;
            list.prepend(bar);
        }

        tbody.innerHTML = '<tr><td colspan="5" class="text-center text-muted">...</td></tr>';

        fetch('action.php?action=preview_spam_matches')
            .then(r => r.json())
            .then(data => {
                const barNow = document.getElementById('scan-progress-li');
                if (barNow) barNow.remove();
                isScanning = false;
                tbody.innerHTML = '';

                if (data.matches && data.matches.length > 0) {
                    let count = 1;
                    data.matches.forEach(m => {
                        const tr = document.createElement('tr');
                        const kw = m.matched_keyword;
                        const badgeClass = getBadgeClass(kw);

                        tr.innerHTML = `
                     <td><small class="text-muted">${count}</small></td>
                     <td><small class="text-muted">#${m.id}</small></td>
                     <td><small>${m.sender_name || m.from}</small></td>
                     <td><small>${m.subject.substring(0, 30)}...</small></td>
                     <td><span class="badge ${badgeClass}">${kw}</span></td>
                 `;
                        tbody.appendChild(tr);
                        count++;
                    });
                } else {
                    const filters = data.active_keywords ? data.active_keywords.join(', ') : 'Aucun';
                    tbody.innerHTML = `<tr><td colspan="5" class="text-center text-muted text-success">
                   <div class="mb-0 py-1" style="font-size: 1.1em;">
                       ✅ Aucun spam détecté sur la file d'attente.<br>
                       <span class="badge bg-secondary mt-1">Filtre actif : ${filters}</span>
                   </div>
                </td></tr>`;
                }
            })
            .catch(err => {
                const barNow = document.getElementById('scan-progress-li');
                if (barNow) barNow.remove();
                isScanning = false;
                tbody.innerHTML = `<tr><td colspan="3" class="text-center text-danger">Erreur: ${err.message}</td></tr>`;
            });
    }

    function getBadgeClass(keyword) {
        // Simple hash to pick a color
        let hash = 0;
        for (let i = 0; i < keyword.length; i++) {
            hash = keyword.charCodeAt(i) + ((hash << 5) - hash);
        }

        // Custom fixed mappings if requested
        const lower = keyword.toLowerCase();
        if (lower.includes('wordpress')) return 'bg-danger'; // Red
        if (lower.includes('chris')) return 'bg-primary'; // Blue
        if (lower.includes('bitcoin')) return 'bg-warning text-dark';
        if (lower.includes('casino')) return 'bg-success';

        const colors = [
            'bg-primary', 'bg-secondary', 'bg-success', 'bg-danger',
            'bg-warning text-dark', 'bg-info text-dark', 'bg-light text-dark'
        ];

        const index = Math.abs(hash % colors.length);
        return colors[index];
    }

    function loadKeywords() {
        fetch('action.php?action=get_spam_keywords').then(r => r.json()).then(data => {
            if (data.success && data.keywords) {
                const list = document.getElementById('keyword-list');
                list.innerHTML = '';
                data.keywords.forEach(word => {
                    const li = document.createElement('li');
                    li.className = 'list-group-item d-flex justify-content-between align-items-center';
                    li.innerHTML = `<span>${word}</span> 
                        <button class='btn btn-sm btn-outline-danger' onclick='removeKeyword("${word}")'>X</button>`;
                    list.appendChild(li);
                });
            }
        });
    }

    function addKeyword() {
        const input = document.getElementById('new-keyword');
        const word = input.value.trim();
        if (!word) return;
        const fd = new FormData();
        fd.append('keyword', word);
        fetch('action.php?action=add_spam_keyword', { method: 'POST', body: fd })
            .then(r => r.json()).then(d => { if (d.success) { input.value = ''; loadKeywords(); loadSpamPreview(); } });
    }

    function removeKeyword(word) {
        if (!confirm('Supprimer "' + word + '" ?')) return;
        const fd = new FormData();
        fd.append('word', word);
        fetch('action.php?action=remove_spam_keyword', { method: 'POST', body: fd })
            .then(r => r.json()).then(d => { if (d.success) { loadKeywords(); loadSpamPreview(); } });
    }

    function cleanSpamByKeywords() {
        if (!confirm("⚠️ Confirmer la suppression MASSIVE de tous les mails détectés ci-dessous ?")) return;

        // UI Feedback
        const btn = document.querySelector('button[onclick="cleanSpamByKeywords()"]');
        const originalText = btn.innerHTML;
        btn.innerHTML = "⏳ Nettoyage...";
        btn.disabled = true;

        fetch('action.php?action=trash_spam_keywords')
            .then(r => r.json())
            .then(data => {
                alert(data.message || 'Terminé');
                btn.innerHTML = originalText;
                btn.disabled = false;
                loadSpamPreview(); // Refresh list to show empty
            })
            .catch(err => {
                alert("Erreur: " + err);
                btn.innerHTML = originalText;
                btn.disabled = false;
            });
    }
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>