<?php
// config/config.php

// Charger les identifiants
$credentials = require_once __DIR__ . '/credentials.php';

// --- PATHS ---
define('ROOT_DIR', dirname(__DIR__));
define('DATA_DIR', ROOT_DIR . '/data');
define('LOGS_DIR', DATA_DIR . '/logs');
define('CORE_DIR', ROOT_DIR . '/core');

// --- FILES ---
define('FILE_QUEUE', DATA_DIR . '/queue.csv'); // Pending Review
define('FILE_SEND_QUEUE', DATA_DIR . '/send_queue.csv'); // Ready to send
define('FILE_ARCHIVES', DATA_DIR . '/archives.csv');
define('FILE_SPAM', DATA_DIR . '/spam.csv'); // Mots-clés interdits
define('FILE_FACTURES', DATA_DIR . '/factures.csv'); // Emails de factures
define('FILE_SPAM_LOG', LOGS_DIR . '/spam_filter.log'); // Traceur de blocages
define('FILE_CLIENTS', DATA_DIR . '/clients.csv'); // Cache clients éventuel

// --- SETTINGS ---
define('ZIMBRA_PAUSE_SECONDS', 30);
define('SMTP_MAX_MAILS_PER_MINUTE', 2);
define('SMTP_PAUSE_BETWEEN_MAILS', 30); // 60s / 2 = 30s

// --- ZIMBRA ---
define('ZIMBRA_HOST', $credentials['zimbra_host']);
define('ZIMBRA_USER', $credentials['zimbra_user']);
define('ZIMBRA_PASS', $credentials['zimbra_pass']);

// --- SMTP ---
define('SMTP_HOST', $credentials['smtp_host']);
define('SMTP_USER', $credentials['smtp_user']);
define('SMTP_PASS', $credentials['smtp_pass']);
define('SMTP_PORT', $credentials['smtp_port']);

// --- GROK API ---
define('GROK_API_KEY', $credentials['grok_api_key']);

// --- PRESTASHOP ---
define('PRESTA_API_URL', $credentials['presta_url']);
define('PRESTA_API_KEY', $credentials['presta_key']);
